import { PUBLIC_PRODUCTION_API_ORIGIN, PUBLIC_DEVELOPMENT_API_ORIGIN } from '$env/static/public';

/** @type {import('./$types').PageLoad} */
export async function load({ fetch, params }) {
	const apiOrigin = import.meta.env.DEV
		? PUBLIC_DEVELOPMENT_API_ORIGIN
		: PUBLIC_PRODUCTION_API_ORIGIN;

	try {
		const response = await fetch(`${apiOrigin}/home?lang=${params.lang}`);

		if (!response.ok) {
			throw new Error(`HTTP error! status: ${response.status}`);
		}

		const data = await response.json();

		return {
			home: data
		};
	} catch (error) {
		// Silent error handling for production
		return {
			home: null,
			error: 'Failed to load home data'
		};
	}
}
